
# Binarized Convolutional Neural Networks with Channel Quadrupling and Smooth Downsampling

- For running this evaluation, you should have ImageNet data in **./data** directory. 
-- Before you run the training, **./results** directory should be pre-made. -- In **./results**, a directory is automatically generated, where training checkpoints and logging data are stored. 
- The binarized convolution module is written in dorefanet.py, which supprots n-bit quantization. The n-bit quantized convolutions can be used to 
quantize the depthwise separable convolutions and fully-connected layers. 
- To finish total training on our maching having AMD Ryzen Threadripper 193 PRO 5955WX 16-Cores CPU, 2 NVIDIA RTX 4090 GPUs, and 256-GB RAM,
the total training times of QSB-Net-Large and QB-Net-Small were about 6 and 7.5 days, respectively.
However, the exact training time can depend on the status of computing resource usage. 
When using ReActNet triangle derivative of Sign function, about 30% additional training time will be needed in our evaluations.
 
- The proposed models with Two-Stage+TS (Teacher-Student Training) can reach 71.2%@Top-1 in QSB-Net-Large(SE2).
  In log directory, you can find the training log files for the proposed models, where term 1/1 denote the binarization of weights and features.

- When only the pointwise convolutions were binarized, file naive.out shows 64.6% Top-1 accuracy on ImageNet-1K.
- The following proposed models can achieve Top-1 accuracies as follows:
  QB-Net-Small: 66.9% (qb-net-small_1_1.out)
  QB-Net-Large: 69.8% (qb-net-large_1_1.out)
  QSB-Net-Small: 68.8% (qsb-net-small_1_1.out)
  QSB-Net-Large: 70.6% (qsb-net-large_1_1.out)
  QSB-Net-Large(SE1): 71.1% (qsb-net-large(se1)_1_1.out)
  QSB-Net-Large(SE2): 71.2% (qsb-net-large(se2)_1_1.out)

- In run_ts.sh, you can see the direction for performing training from Two-Stage+TS training. 



